/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.compliance;

import com.quantumdata.cec.CECComplianceMain;
import com.quantumdata.compliance.EDIDDeclareFolder;
import com.quantumdata.compliance.ReportsPanel;
import com.quantumdata.hdcp.HDCPGUI;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.StdConnectionManager;
import com.quantumdata.widgets.QDPanel;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ComplianceGUI
extends JApplet {
    private static final long serialVersionUID = 1L;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Quantum Data Compliance Controller");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(ComplianceGUI.GetPanel(jFrame));
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setLocationRelativeTo(null);
    }

    public void init() {
        this.getContentPane().add(ComplianceGUI.GetPanel(this));
        this.setSize(1000, 700);
        this.setVisible(true);
    }

    public static JScrollPane GetPanel(Component component) {
        Object object;
        QDPanel qDPanel = new QDPanel();
        StdConnectionManager stdConnectionManager = new StdConnectionManager(component);
        RemoteInstrument remoteInstrument = stdConnectionManager.newConnection();
        try {
            remoteInstrument.connect();
        }
        catch (InstrumentException instrumentException) {
            JOptionPane.showMessageDialog(qDPanel, "Unable to connect!", "Error!", 0);
            System.exit(0);
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        try {
            if (remoteInstrument == null) {
                JOptionPane.showMessageDialog(qDPanel, "Unable to read options!", "Error!", 0);
            }
            if ((object = remoteInstrument.sendCmd("*IDN?")).isError()) {
                JOptionPane.showMessageDialog(qDPanel, "Unable to read options!", "Error!", 0);
            }
            string = object.getResponse();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(qDPanel, "Unable to read options!", "Error!", 0);
            System.exit(0);
        }
        object = new StringTokenizer(string, ",");
        if (((StringTokenizer)object).countTokens() > 1) {
            string = ((StringTokenizer)object).nextToken();
            string = ((StringTokenizer)object).nextToken();
        }
        object = new StringTokenizer(string, "-");
        int n = ((StringTokenizer)object).countTokens();
        for (int i = 0; i < n; ++i) {
            string = ((StringTokenizer)object).nextToken();
            if (string.equals("DPLL1")) {
                bl3 = true;
                continue;
            }
            if (string.equals("DPLL2")) {
                bl3 = true;
                continue;
            }
            if (string.equals("TME")) {
                bl = true;
                continue;
            }
            if (!string.equals("HDCP")) continue;
            bl2 = true;
        }
        if (bl) {
            CECComplianceMain cECComplianceMain = new CECComplianceMain();
            cECComplianceMain.SetInstrument(remoteInstrument);
            jTabbedPane.addTab("CEC", cECComplianceMain);
        }
        if (bl2) {
            HDCPGUI hDCPGUI = new HDCPGUI();
            hDCPGUI.setInstrument(remoteInstrument);
            jTabbedPane.addTab("HDCP", hDCPGUI);
        }
        EDIDDeclareFolder eDIDDeclareFolder = new EDIDDeclareFolder();
        eDIDDeclareFolder.setInstrument(remoteInstrument);
        jTabbedPane.addTab("EDID", eDIDDeclareFolder);
        ReportsPanel reportsPanel = new ReportsPanel(remoteInstrument);
        jTabbedPane.addTab("Reports", reportsPanel);
        qDPanel.add(jTabbedPane);
        return new JScrollPane(qDPanel);
    }
}

